<?php
/**
 * Template Name: AirMech About Page 
 *
 * @package WordPress
 * @subpackage AirMech_Arena
 */
?>
<?php get_header(); ?>
	<div class="container">
		<div id="about-aimrech">
			<div class="row">
				<div class="title">
					<div class="col-lg-6">
						<h2><?php echo get_the_title(); ?> </h2>
					</div> <!-- col-2-lg -->
					<div class="col-lg-6">
						<img src="<?php echo IMAGES ?>/redflair.png" alt="" class="img-responsive visible-lg">
					</div>
				</div> <!-- title -->
			</div> <!-- row -->
			<div class="row">
				<div class="col-lg-12">
					<hr>
				</div> <!-- col-lg-12 -->
			</div> <!-- row -->
			<div class="row">
				<div class="video-section">
					<div class="col-lg-7">
						<div clas="video-container">
							<iframe width="560" height="315" src="<?php echo get_field('video_link'); ?>" frameborder="0" allowfullscreen></iframe>
						</div> <!-- video-container -->
					</div>
					<div class="col-lg-5">
						<div class="video-description">
							<h3><?php echo get_field('title'); ?></h3>
							<p><?php echo get_field('video_description'); ?></p>
						</div> <!-- video-description -->
					</div>
				</div> <!-- video-section -->
			</div> <!-- row -->
			<div class="row">
				<div class="col-lg-12">
					<div class="the-arena">
						<h2>The Arena</h2>
						<ul class="nav nav-tabs" role="tablist">
							<li class="active" style="z-index: 5"><a href="#home" role="tab" data-toggle="tab"><?php the_field('first_tab_title'); ?></a></li>
							<li style="z-index: 3"><a href="#profile" role="tab" data-toggle="tab"><?php the_field('second_tab_title'); ?></a></li>
							<li style="z-index: 2"><a href="#messages" role="tab" data-toggle="tab"><?php the_field('third_tab_title'); ?></a></li>
							<li style="z-index: 1"><a href="#settings" role="tab" data-toggle="tab"><?php the_field('fourth_tab_title'); ?></a></li>
						</ul><!-- tabs -->

						<div class="tab-content" id="contents">
							<div class="tab-pane active" id="home">
								<ul>
									<li>
										<?php echo the_field('left_column_content'); ?>
									</li>
									<li>
										<?php echo the_field('right_column_content'); ?>
									</li>
								</ul>
							</div> <!-- content 1 -->
							<div class="tab-pane" id="profile">
								<ul>
									<li>
										<?php echo the_field('second_left_column_content'); ?>
									</li>
									<li>
										<?php echo the_field('second_right_column_content'); ?>
									</li>
								</ul>
							</div> <!-- content 2 -->
							<div class="tab-pane" id="messages">
								<ul>
									<li>
										<?php echo the_field('third_left_column_content'); ?>
									</li>
									<li>
										<?php echo the_field('third_right_column_content'); ?>
									</li>
								</ul>
							</div> <!-- content 3 -->
							<div class="tab-pane" id="settings">
								<ul>
									<li>
										<?php echo the_field('fourth_left_column_content'); ?>
									</li>
									<li>
										<?php echo the_field('fourth_right_column_content'); ?>
									</li>
								</ul>
							</div> <!-- content 4 -->
						</div><!-- content -->	
						<script>
						$('#myTab a[href="#profile"]').tab('show') // Select tab by name
						$('#myTab a:first').tab('show') // Select first tab
						$('#myTab a:last').tab('show') // Select last tab
						$('#myTab li:eq(2) a').tab('show') // Select third tab (0-indexed)
						</script>
					</div> <!-- tabs-sections -->
				</div> <!-- col-lg-12 -->
			</div> <!-- row -->			
			<div class="row">
				<div class="col-lg-12">
					<div class="carousel-container">					
						<div class="infiniteCarousel">
						<h3>Mechs</h3>
						<?php 
							$args = array(
								'post_type' => 'ama_mechs'
							);
							global $post; $myposts = get_posts($args); 
						?>
							<div class="wrapper">
								<ul id="mech_slider_carousel">
									<?php foreach($myposts as $post) : ?> 
										<li><?php the_post_thumbnail();  ?><p><?php the_title(); ?></p></li>
									<?php endforeach; ?> 
								</ul>
								 <?php wp_reset_query(); ?> 
								<div class="bx-controls-auto" id="left_rgt_ar">
									<a href="javascript:void(0)" onclick="mech_slide_left2()" class="bx-prev">Start</a>
									<a href="javascript:void(0)" onclick="mech_slide_right2()"class="bx-next">Stop</a>
								</div>
							</div>
						</div> <!-- infiniteCarousel -->
					</div> <!-- carousel-container -->
				</div> <!-- col-lg-12 -->
			</div> <!-- row -->
			<div class="row">
				<div class="col-lg-12">
					<div class="carousel-container">
						<div class="infiniteCarousel">
						<h3>Pilots</h3>
						<?php 
							$args = array(
									'post_type' => 'ama_pilots'
							);
							global $post; $myposts = get_posts($args); 
						?>
							<div class="wrapper">
								<ul id="pilot_slider_carousel">
									<?php foreach($myposts as $post) : ?> 
										<li><?php the_post_thumbnail();  ?><p><?php the_title(); ?></p></li>
									<?php endforeach; ?> 
								</ul>
								 <?php wp_reset_query(); ?> 
								<div class="bx-controls-auto" id="left_rgt_ar">
									<a href="javascript:void(0)" onclick="pilot_slide_left2()" class="bx-prev">Start</a>
									<a href="javascript:void(0)" onclick="pilot_slide_right2()"class="bx-next">Stop</a>
								</div>
							</div>
						</div><!--  infiniteCarousel -->
					</div> <!-- carousel-container -->
				</div> <!-- col-lg-12 -->
			</div> <!-- row -->
			<div class="row">
				<div class="col-lg-12">
					<div class="carousel-container">
						<div class="infiniteCarousel_units">
							<h3>Pilots</h3>
							<?php 
								$args = array(
										'post_type' => 'ama_units'
								);
								global $post; $myposts = get_posts($args); 
							?>
								<div class="wrapper">
									<ul id="unit_slider_carousel">
										<?php foreach($myposts as $post) : ?> 
											<li><?php the_post_thumbnail();  ?><p><?php the_title(); ?></p></li>
										<?php endforeach; ?> 
										 <?php wp_reset_query(); ?> 
									</ul>
									<div class="bx-controls-auto" id="left_rgt_ar">
										<a href="javascript:void(0)" onclick="unit_slide_left2()" class="bx-prev">Start</a>
										<a href="javascript:void(0)" onclick="unit_slide_right2()"class="bx-next">Stop</a>
									</div>
								</div>
							</div> <!-- infiniteCarousel_units -->
					</div> <!-- carousel-container -->
				</div> <!-- col-lg-12 -->
			</div> <!-- row -->
			<div class="row">
				<div class="game-modes">
					<h3><?php echo the_field('bottom_section_title'); ?></h3>
					<div class="col-lg-12">
						<ul class="modes">
							<li>
								<?php $bottom_first_column_image = get_field('bottom_first_column_image'); ?>
								<?php if(!empty($bottom_first_column_image)): ?> 
									<img src="<?php echo $bottom_first_column_image['url']; ?>" alt="" class="img-responsive">
								<?php endif; ?>
								<h4><?php echo the_field('bottom_first_column_title'); ?></h4>
								<p><?php echo the_field('bottom_first_column_descriptions'); ?></p>								
							</li>
							<li>
								<?php $bottom_second_column_image = get_field('bottom_second_column_image'); ?>
								<?php if(!empty($bottom_second_column_image)): ?> 
									<img src="<?php echo $bottom_second_column_image['url']; ?>" alt="" class="img-responsive">
								<?php endif; ?>
								<h4><?php echo the_field('bottom_second_column_title'); ?></h4>
								<p><?php echo the_field('bottom_second_column_description'); ?></p>								
							</li>
							<li>
								<?php $bottom_third_column_image = get_field('bottom_third_column_image'); ?>
								<?php if(!empty($bottom_third_column_image)): ?> 
									<img src="<?php echo $bottom_third_column_image['url']; ?>" alt="" class="img-responsive">
								<?php endif; ?>
								<h4><?php echo the_field('bottom_third_column_title'); ?></h4>
								<p><?php echo the_field('bottom_third_column_descriptions'); ?></p>								
							</li>							
						</ul>
					</div>
				</div>
			</div>
		</div> <!-- about-aimrech -->
	</div> <!-- container -->
<?php get_footer(); ?>`