<?php
/**
 * Template Name: AirMech Mechs Page
 *
 * @package WordPress
 * @subpackage AirMech_Arena
 */
?>
<?php get_header(); ?>
	<div class="container">
		<div id="mechs-main-wrapper">
			<div class="title">
				<div class="row">
						<div class="col-lg-5">
							<h2><?php echo get_the_title(); ?></h2>
						</div> <!-- col-2-lg -->
						<div class="col-lg-7">
							<img src="<?php echo IMAGES ?>/redflair.png" alt="" class="pull-right visible-lg">
						</div>
				</div>  <!-- row -->
				<div class="row">
					<hr>
				</div> <!-- row -->
			</div> <!-- title -->
			<div class="row">
				<div class="mechs">
					<?php 
						$args = array(
							'post_type' => 'ama_mechs',
							'posts_per_page' => 5
						);
						$the_query = new WP_Query( $args ); 
					?>
					<?php if ( $the_query->have_posts() ) : ?>
					<ul>
						<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
							<li>
								<div class="col-lg-4">
									<div class="mech-image"><?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive center-block' ) ); ?></div>
								</div>
								<div class="col-lg-8">
									<div class="mech-descriptions">	
										<h3><?php the_title(); ?></h3>
										<p><?php the_content(); ?></p>
										<div class="buy-skin-btn"><a href="#"><img src="<?php echo IMAGES;  ?>/buy-skin-btn.png" alt="Buy Skin"></a></div>
									</div>
								</div> <!-- mech-descriptions -->
							</li>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>	
					</ul>
					<?php else : ?>
						<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
					<?php endif; ?>
				</div> <!-- mechs -->
			</div> <!-- row -->
		</div>  <!-- mechs-main-wrapper -->
	</div> <!-- container -->
<?php get_footer(); ?>