<?php
/**
 * Template Name: AirMech Pilot Page 
 *
 * @package WordPress
 * @subpackage AirMech_Arena
 */
?>
<?php get_header(); ?>
	<div class="container">
		<div id="pilots-main-wrapper">
			<div class="title">
				<div class="row">
						<div class="col-lg-4">
							<h2>About The Pilots</h2>
						</div> <!-- col-2-lg -->
						<div class="col-lg-8">
							<img src="<?php echo IMAGES ?>/redflair.png" alt="Redflair" class="visible-lg">
						</div>
				</div>  <!-- row -->
				<div class="row">
					<hr>
				</div> <!-- row -->
			</div> <!-- title -->
			<div class="row">
				<div class="pilot-lists">
					<?php 
						$args = array(
								'showposts' => -1,
								'post_type' => 'ama_pilots'
						);
						// global $post; $myposts = get_posts($args); 
						$the_query = new WP_Query( $args ); 
					?>
					<?php if ( $the_query->have_posts() ) : ?>				
						<ul>
							<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
								<li>
									<div class="col-lg-4 col-md-4 col-sm-4">
										<div class="pilot-featured-image">
											<?php if (has_post_thumbnail( $post->ID ) ): ?>
												<?php $pilot_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
												<img src="<?php echo $pilot_image[0]; ?>" alt="<?php the_title(); ?>" class="img-responsive">
											<?php endif; ?>										
										</div> <!-- pilot-featured-image -->
									</div> <!-- col-lg-3 -->
									<div class="col-lg-8 col-md-8 col-sm-8">
										<div class="pilot-descriptions">
											<h3><?php the_title(); ?></h3>
											<?php echo the_content(); ?>
										</div>
									</div> <!-- col-lg-9 -->
								</li>
							<?php endwhile; ?>
							<?php wp_reset_postdata(); ?>
						</ul>
					<?php else : ?>
						<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
					<?php endif; ?>
				</div> <!-- pilot-lists -->
			</div> <!-- row -->				
		</div> <!-- pilots-main-wrapper -->
	</div> <!-- container -->
<?php get_footer(); ?>