<?php
/*------------------------------------*\
    Flashman Studios Theme Options
\*------------------------------------*/
class AirMech_Theme_Options{
	public $options;
	public function __construct(){
		$this->register_settings_and_fields();
	}
	static function add_menu_page(){
		add_menu_page(
			'Theme Options',
			'Theme Options',
			'nosuchcapability',
			'theme-options',
			'theme_options_display'
		);
		add_submenu_page(
            'theme-options',                   
            'General Settings',                     
            'General Settings',                       
            'manage_options',                       
            'general-settings-option',                       
            'theme_options_display'           
        );
        add_submenu_page(
            'theme-options',                   
            'Social Links',                     
            'Social Links',                       
            'manage_options',                       
            'social-settings-option',                       
            'theme_options_display'           
        );
		function theme_options_display(){
            ?>
                <div class="wrap">
                    <div id="icon-plugins" class="icon32"></div>
                    <h2>AirMech Arena Theme Options</h2>
                    <?php settings_errors(); ?>
                    <?php
                        $active_tab = 'general-settings-option';
                        if(isset($_GET['page'])){
                            $active_tab = $_GET['page'];
                        }
                    ?>
                    <h2 class="nav-tab-wrapper">
                        <a href="?page=general-settings-option" class="nav-tab <?php echo 'general-settings-option' == $active_tab || 'theme-options' == $active_tab ? 'nav-tab-active' : ''; ?>">General Settings</a>
                        <a href="?page=social-settings-option" class="nav-tab <?php echo $active_tab == 'social-settings-option' ? 'nav-tab-active' : ''; ?>">Social</a>
                    </h2>

                    <form method="post" action="options.php" enctype="multipart/form-data">
                        <?php

                            if('general-settings-option' == $active_tab) {
                                settings_fields('general_settings_section');
                                do_settings_sections('general-settings-option');
                            } elseif('social-settings-option' == $active_tab) {
                                settings_fields('social_settings_section');
                                do_settings_sections('social-settings-option');
                            }  
                            submit_button();
                        ?>
                    </form>
                </div> <!-- end wrap -->
            <?php
        };

        function general_settings_description_display(){
            echo 'General Settings:';
        };
        function social_option_description_display(){
            echo 'Enter your Social Links.';
        };
	}
	public function register_settings_and_fields(){
        	require_once('settings-fields.php');
        	require_once('inputs.php');
     }
} // END class AirMech_Theme_Options
add_action('admin_menu', function (){
	AirMech_Theme_Options::add_menu_page();
});
add_action('admin_init', function(){
    new AirMech_Theme_Options;
});
?>