<?php
/**
 * Template Name: AirMech Arena League Page  
 *
 * @package WordPress
 * @subpackage AirMech_Arena
 */
?>
<?php get_header(); ?>
	<div class="container">
		<div id="airmech-arena-league">
			<div class="title">
				<div class="row">
						<div class="col-lg-7">
							<h2><?php echo get_the_title(); ?></h2>
						</div> <!-- col-2-lg -->
						<div class="col-lg-5">
							<img src="<?php echo IMAGES ?>/redflair.png" alt="" class="pull-right visible-lg">
						</div>
				</div>  <!-- row -->
				<div class="row">
					<hr>
				</div>
			</div> <!-- title -->
			<div class="row">
				<div class="info">
					<div class="col-lg-5 col-md-5 col-sm-5">
						<div class="info-img">
							<?php $featured_image = get_field('featured_image'); ?>
							<?php if(!empty($featured_image)): ?> 
								<img src="<?php echo $featured_image['url']; ?>" alt="" class="img-responsive center-block">
							<?php endif; ?>
						</div>
					</div>
					<div class="col-lg-7 col-md-7 col-sm-7">
						<div class="info-msg">
							<h3><?php the_field('first_section_title'); ?></h3>
							<p><?php the_field('first_section_descriptions'); ?></p>
						</div>
					</div>
				</div> <!-- info -->
			</div><!--  row -->
			<div class="row">
				<div class="col-lg-12">
					<div class="competition">
						<h3><?php the_field('second_section_title'); ?></h3>
						<?php $second_section_image = get_field('second_section_image'); ?>
						<?php if(!empty($second_section_image)): ?> 
							<img src="<?php echo $second_section_image['url']; ?>" alt="" class="img-responsive">
						<?php endif; ?>
					</div>					
				</div>
			</div> <!-- row -->
			<div class="row">
				<div class="prize">
					<div class="col-lg-6">
						<div class="prize-decriptions">
							<h3><?php the_field('third_section_title'); ?></h3>
							<p><?php the_field('third_section_descriptions'); ?></p>
							<?php $third_section_image = get_field('third_section_image'); ?>
							<?php if(!empty($third_section_image)): ?> 
								<img src="<?php echo $third_section_image['url']; ?>" alt="" class="img-responsive center-block">
							<?php endif; ?>
						</div><!--  prize-decriptions -->
					</div>
					<div class="col-lg-6">
						<div class="prize-lists center-block">
							<?php 
								$shortcode = get_field('gallery_shortcode');
							?>
							<?php echo do_shortcode($shortcode); ?>											
						</div> <!-- prize-lists center-block -->
					</div>
				</div> <!-- prize -->
			</div> <!-- row -->
			<div class="row">
				<div class="registrations">
					<div class="row">
						<h3>Registration and Getting Started</h3>
					</div>
					<div class="row">
						<div class="col-lg-4">
							<div class="registration-column">
								<?php $first_column_image = get_field('first_column_image'); ?>
								<?php if(!empty($first_column_image)): ?> 
									<img src="<?php echo $first_column_image['url']; ?>" alt="" class="img-responsive center-block">
								<?php endif; ?>
								<h4><?php the_field('first_column_title'); ?></h4>
								<p><?php the_field('first_column_description'); ?></p>
							</div> <!-- registration-column -->
						</div> <!-- col-lg-4 -->
						<div class="col-lg-4">
							<div class="registration-column">						
								<?php $second_column_image = get_field('second_column_image'); ?>
								<?php if(!empty($second_column_image)): ?> 
									<img src="<?php echo $second_column_image['url']; ?>" alt="" class="img-responsive center-block">
								<?php endif; ?>
								<h4><?php the_field('second_column_title'); ?></h4>
								<p><?php the_field('second_column_description'); ?></p>
							</div> <!-- registration-column -->
						</div> <!-- col-lg-4 -->
						<div class="col-lg-4">
							<div class="registration-column">	
								<?php $third_column_image = get_field('third_column_image'); ?>
								<?php if(!empty($third_column_image)): ?> 
									<img src="<?php echo $third_column_image['url']; ?>" alt="" class="img-responsive center-block">
								<?php endif; ?>
								<h4><?php the_field('third_column_title'); ?></h4>
								<p><?php the_field('third_column_description'); ?></p>
							</div> <!-- registration-column -->
						</div> <!-- col-lg-4 -->
					</div>
					<div class="row">
						<div class="col-lg-12">
							<a href="<?php the_field('get_started_button_link'); ?>"><img src="<?php echo IMAGES; ?>/get-started-btn.png" alt="Get Started" class="center-block img-responsive"></a>
						</div>
					</div>
				</div>
				<div class="rules">
					<div class="row">
						<div class="col-lg-12"><h3><?php the_field('fifth_section_title'); ?></h3></div>
					</div>
						<div class="rules-images">							
							<div class="col-lg-6">
								<div class="rules-column"><?php $first_image = get_field('first_image'); ?>
									<?php if(!empty($first_image)): ?> 
										<img src="<?php echo $first_image['url']; ?>" alt="" class="img-responsive center-block">
									<?php endif; ?>
								</div> <!-- rules-column -->
							</div> <!-- col-lg-6 -->
							<div class="col-lg-6">
								<div class="rules-column"><?php $second_image = get_field('second_image'); ?>
									<?php if(!empty($second_image)): ?> 
										<img src="<?php echo $second_image['url']; ?>" alt="" class="img-responsive center-block">
									<?php endif; ?>
								</div> <!-- rules-column -->
							</div> <!-- col-lg-6 -->
						</div> <!--  center-block -->
					<div class="row">
						<div class="col-lg-12"><a href="<?php the_field('read_the_complete_rules_button_link'); ?>" class="read-rules-btn center-block"><img src="<?php echo IMAGES; ?>/read-rules-btn.png" alt="Read The Complete Rules" class="img-responsive center-block"></a></div>
					</div>
				</div> <!-- rules -->
			</div> <!-- row -->
		</div> <!-- airmech-arena-league -->
	</div> <!-- container -->
<?php get_footer(); ?>