<?php
/**
 * Template Name: AirMech Partners Page
 *
 * @package WordPress
 * @subpackage AirMech_Arena
 */
?>
<?php get_header(); ?>
	<div class="container">
		<div id="partners">
			<div class="title">
				<div class="row">
						<div class="col-lg-4">
							<h2><?php echo get_the_title(); ?></h2>
						</div> <!-- col-2-lg -->
						<div class="col-lg-8">
							<img src="<?php echo IMAGES ?>/redflair-media.png" alt="" class="visible-lg">
						</div>
					
				</div>  <!-- row -->
				<div class="row">
					<hr>
				</div> <!-- row -->
			</div> <!-- title -->
			<div class="partner-list">
				<?php 
					$args = array(
							'showposts' => -1,
							'post_type' => 'ama_partners'
					);
					// global $post; $myposts = get_posts($args); 
					$the_query = new WP_Query( $args ); 
				?>
				<?php if ( $the_query->have_posts() ) : ?>
				<ul>
					<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
						<li>
							<div class="row">
								<div class="partners-list-wrapper">
									<div class="col-lg-8">
										<div class="featured"><img src="<?php echo IMAGES; ?>/white.png" class="img-responsive"></div>
									</div>
									<div class="col-lg-4">
										<div class="details">
											<?php $content_image = get_field('content_image'); ?>
											<?php if(!empty($content_image)): ?> 
												<img src="<?php echo $content_image['url']; ?>" alt="" class="img-responsive">
											<?php endif; ?>
											<?php echo the_content(); ?>
											</div>
									</div>
								</div> <!-- partners-list-wrapper -->
							</div> <!-- row -->
						</li>
					<?php endwhile; ?>
					<?php wp_reset_postdata(); ?>	
				</ul>
				<?php else : ?>
					<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
				<?php endif; ?>
			</div>
		</div> <!-- partners -->
	</div> <!-- container -->
<?php get_footer(); ?>