<?php
/**
 * Template Name: AirMech Units Page
 *
 * @package WordPress
 * @subpackage AirMech_Arena
 */
?>
<?php get_header(); ?>
	<div class="container">
		<div id="units-main-wrapper">
			<div class="title">
				<div class="row">
						<div class="col-lg-4">
							<h2><?php echo get_the_title(); ?></h2>
						</div> <!-- col-2-lg -->
						<div class="col-lg-8">
							<img src="<?php echo IMAGES ?>/redflair.png" alt="Redflair" class="visible-lg">
						</div>
				</div>  <!-- row -->
				<div class="row">
					<hr>
				</div> <!-- row -->
			</div> <!-- title -->			
			<div class="units-list">
				<div class="row">
					<?php 
						$args = array(
								'showposts' => -1,
								'post_type' => 'ama_units'
						);
						// global $post; $myposts = get_posts($args); 
						$the_query = new WP_Query( $args ); 
					?>
					<?php if ( $the_query->have_posts() ) : ?>
					<ul>
						<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
						<li class="unit">
							<div class="row">
								<div class="unit-name">
									<h3><?php the_title(); ?></h3>
								</div> <!-- unit-name -->
							</div> <!-- row -->
							<div class="row">
								<div class="col-lg-4">
									<div class="featured-unit-image">
										<?php if (has_post_thumbnail( $post->ID ) ): ?>
											<?php $unit_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
											<img src="<?php echo $unit_image[0]; ?>" alt="<?php the_title(); ?>" class="img-responsive center-block">
										<?php endif; ?>
									</div>
								</div> <!-- col-lg-4 -->
								<div class="col-lg-8">
									<div class="statistics">
										<?php echo the_content(); ?>
									</div>
								</div>
							</div> <!-- row -->
							<div class="unit-descriptions">
								<p><?php the_field('units_descriptions'); ?></p>
							</div>
						</li> <!-- unit -->
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>	
					</ul>
				<?php else : ?>
					<p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
				<?php endif; ?>
				</div> <!-- row -->
			</div> <!-- units-list -->
		</div> <!-- units-main-wrapper -->
	</div> <!-- container -->
<?php get_footer(); ?>