<?php 
/*
Single Post Template:News Post
*/
get_header('news'); ?>
	<div class="container">
			<div class="row">
				<div id="news-post-wrapper">
					<div class="col-lg-8">
						<div class="single-news-post">
							<?php if ( have_posts() ) :
								while ( have_posts() ) : the_post(); ?>
									<h3><?php the_title(); ?></h3>
									<p class="author">Posted By: <a href="#"><?php the_author(); ?></a>  /  <?php the_tags( '', ', ', '' ); ?>   /  <a href="<?php comments_link(); ?>"><?php comments_number( 'No Comments', 'One Comment', '% Comments' ); ?>.</a>  /  <?php echo get_the_date('F jS, Y'); ?></p>
									<?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive' ) ); ?>
									<div class="post-content"><?php the_content(); ?></div>
									<div class="post-navigation">
										<?php previous_post_link( '%link', '< Older', TRUE ); ?> / <?php next_post_link( '%link', 'Newer >', TRUE ); ?>
									</div>
								<?php	endwhile;
								else :
									echo wpautop( 'Sorry, no posts were found' );
								endif; ?>
							<img src="<?php echo IMAGES ?>/redflair.png" alt="" class="img-responsive visible-lg pull-right redflair">
							<div id="comments">
								<hr>
								<h4>Comments</h4>
								<?php comments_template(); ?>
							</div>
						</div> <!-- END single-news-post -->						
					</div>
					<div class="col-lg-4">
						<div id="main-sidebar">
							<aside>
								<div class="sidebar-top">
									<?php if(function_exists('dynamic_sidebar') && dynamic_sidebar('news-sidebar-widgets')) : else : ?>
												
									<?php endif; ?>		
								</div> <!-- sidebar-top -->
								<div class="ad1">
									<?php if(function_exists('dynamic_sidebar') && dynamic_sidebar('ads1-sidebar-widgets')) : else : ?>
												
									<?php endif; ?>		
								</div> <!-- ad1 -->
							</aside>
						</div>
					</div>
				</div>	<!-- END single-new-wrapper -->
			</div>
		</div>	
<?php get_footer('news'); ?>