<?php 
/**
 * The template for displaying Comments
 *
 * The area of the page that contains comments and the comment form.
 *
 * @package WordPress
 * @subpackage Airmech Arena
 * @since Airmech Arena 1.0
 */

/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
$comment_args = array( 
	'title_reply'=>'Got Something To Say:',
	'fields' => apply_filters( 'comment_form_default_fields', array(
																		'author' => '<p class="comment-form-author">' . '<label for="author">' . __( 'Name:' ) . '</label> ' . ( $req ? '<span>*</span>' : '' ) .
																		'<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></p>',   
																		'email'  => '<p class="comment-form-email">' .
																		'<label for="email">' . __( 'Email:' ) . '</label> ' . ( $req ? '<span>*</span>' : '' ) .
																		'<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' />'.'</p>', 'url'    => '' ) ),
																		'comment_field' => '<p>' .
														                '<label for="comment">' . __( 'Let us know what you have to say:' ) . '</label></p>' .
														                '<p><textarea id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea>' .
														                '</p>',
																		'comment_notes_after' => '',

);
comment_form($comment_args); 
if ( have_comments() ) {
	wp_list_comments(
		array(
			'type' => 'comment',
			'callback' => 'comments_feed_template_callback'
		)
	);
}
if ( ! comments_open() ) {
// end have_comments() 
	_e( '<p class="no-comment">Comments are closed.</p>'); 
}
?>

  
