<?php
/**
 * Template Name: AirMech Home Page
 *
 * @package WordPress
 * @subpackage AirMech_Arena
 */
?>
<?php get_header(); ?>
	<div class="container">
		<div class="row">
					<div class="main-slider-section">
						<div class="col-lg-8 col-md-8 col-sm-8">
							<?php if( function_exists('cyclone_slider') ) cyclone_slider('homepage-slider'); ?>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-4">
							<div id="newsletter">
								<?php if(function_exists('dynamic_sidebar') && dynamic_sidebar('latest-news-widgets')) : else : ?>
									
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>				
		</div> <!-- END top-section -->
		<div id="middle-section">
			<div class="middle-top-bar"></div>
			<div class="container">
				<div class="row">
					<div class="col-lg-12"><h2><?php the_field('middle_content_title') ?></h2></div>
				</div>
				<div class="row">
					<div class="middle-section-content">
						<div class="col-lg-4">
							<?php $register_image = get_field('register_image'); ?>
							<?php if(!empty($register_image)): ?>
								<img src="<?php echo $register_image['url']; ?>" alt="Airmech" class="img-responsive visible-lg">
							<?php endif; ?>
						</div>
						<div class="col-lg-8 col-md-12 div-player">
							<div class="video-container">
								<iframe width="100%" height="100%" src="<?php echo get_field('featured_video_link'); ?>" frameborder="0" allowfullscreen></iframe>
							</div> <!-- video-container -->
							<div>
								<ul class="middle-section-btn">
									<li><a href="<?php the_field('button_1_link') ?>"><img src="<?php echo IMAGES; ?>/about_button.png" alt="<?php echo $btn_1_title; ?>" class="about-game img-responsive"></a></li>
									<li><a href="<?php the_field('button_3_link') ?>"><img src="<?php echo IMAGES; ?>/download_button.png" alt="<?php echo $btn_3_title; ?>" class="download-free img-responsive"></a></li>
								</ul>
							</div>
						</div>
					</div> <!-- END middle-section-content -->
				</div>
			</div>
		</div> <!-- END middle-section -->
		<div id="bottom-section">
			<div class="bottom-top-bar"></div>
			<div class="container">
				<div class="row">
					<div class="col-lg-12 bottom-top-header-bg">
						<h2><?php the_field('bottom_section_title'); ?></h2>
					</div>
				</div>
				<div class="register-section-wrapper">
					<div class="register-section">
						<div class="row">
							<div class="col-lg-9">
								<p class="register-msg">
									<?php the_field('register_message'); ?>
								</p>
							</div>
							<div class="col-lg-3">
								<a href="<?php the_field('register_link'); ?>"><img src="<?php echo IMAGES; ?>/bottom-register-btn.png" alt="Register Now" class="middle-register-btn img-responsive"></a>
							</div>
						</div>
					</div>
				</div> <!-- END register-section -->
				<div class="league">
					<div class="row">
						<div class="col-lg-5">
							<div class="upcoming-schedule">
							<h3>Upcoming Schedule</h3>
							<hr>
								<div class="upcoming-header">
								</div>
								<div class="upcoming-events">
									<ul>
										<li><img class="pax" src="<?php echo IMAGES; ?>/pax.png" alt=""><a href="#">Event #1 - Lorem ipsum dolor sit amet.</a></li>
										<li><img class="trophy" src="<?php echo IMAGES; ?>/trophy.png" alt=""><a href="#">Event #2 - Lorem ipsum dolor sit amet.</a></li>
										<li><img class="trophy" src="<?php echo IMAGES; ?>/trophy.png" alt=""><a href="#">Event #3 - Lorem ipsum dolor sit amet.</a></li>
									</ul>
								</div>
							</div>
						</div>
						<div class="col-lg-7">
							<h3>Current League Standings</h3>
							<hr>
							<div class="team-standing">
								<table>
									<tr>
										<th colspan="3">
										<table><tr><th>Rank</th><th valign="middle"><img src="<?php echo IMAGES; ?>/tableline.png"></th><th>Team</th><th valign="middle"><img src="<?php echo IMAGES; ?>/tableline.png"></th><th>Total Wins</th></tr></table>
										</th>
									</tr>
									<tr>
										<td>1</td><td>Evil Genuis</td><td>50</td>
									<tr>
										<td>2</td><td>Team Liquid</td><td>40</td>
									</tr>
									<tr>
										<td>3</td><td>SK Telecom</td><td>30</td>
									</tr>
									<tr>
										<td>4</td><td>Razer</td><td>20</td>
									</tr>
									<tr>
										<td>5</td><td>CM</td><td>10</td>
									</tr>
								</table>
							</div> <!-- END team-standing -->
						</div>
					</div>
				</div> <!-- END league -->
				<div class="hall-of-destruction">
					<div class="title">
						<div class="row">
							<div class="col-lg-6">
								<h3>Hall Of Destruction</h3>
							</div>
							<div class="col-lg-6">
								<img src="<?php echo IMAGES ?>/redflair.png" alt="" class="trapezoid visible-lg pull-right">
							</div>			
						</div>						
					</div> <!-- title -->
					<hr>
				</div>
				<div class="league-plays">
						<div class="row">
							<div class="col-lg-8">
								<div class="mechs-destroyed">
									<div class="row">
										<h4 class="pull-left">Mechs Destroyed in League Play</h4><span class="white-line pull-right visible-lg">&nbsp;</span>
									</div> <!-- row -->
									<div class="row">
										<div class="col-lg-6 col-md-6">
											<div class="players" >
												<table>
												<thead>
													<tr>
														<th colspan="2">Player</th>
													</tr>
												</thead>
												<tbody>
												<?php $count = 1;
												while($count != 11){
												?>
													<tr>
														<td>&nbsp;</td><td></td>
													</tr>
												<?php $count++; } ?>
												</tbody>
												</table>										
											</div>
										</div>
										<div class="col-lg-6 col-md-6">
											<div class="team">
												<table>
												<thead>
													<tr>
														<th colspan="2">Team</th>
													</tr>
												</thead>
												<tbody>
												<?php $count = 1;
												while($count != 11){
												?>
													<tr>
														<td>&nbsp;</td><td></td>
													</tr>
												<?php $count++; } ?>
												</tbody>
												</table>										
											</div>
										</div>										
									</div>									
								</div>
							</div>
							<div class="col-lg-4">
								<div class="total-wins">
									<h4>Total Wins in League Play</h4>	
									<table>
										<thead>
											<tr>
												<th colspan="2">Player</th>
											</tr>
										</thead>
										<tbody>		
											<?php $count = 1;
												while($count != 11){
											?>
											<tr>
												<td>&nbsp;</td><td></td>
											</tr>
											<?php $count++; } ?>
										</tbody>
									</table> <!-- total-wins -->								
								</div>
							</div>
						</div>
				</div> <!-- END league-plays -->
			</div>
<?php get_footer(); ?>


